package com.hero.objects.powers;

import org.jdom.Element;

import com.hero.HeroDesigner;
import com.hero.objects.GenericObject;
import com.hero.ui.dialog.ArmorDialog;
import com.hero.ui.dialog.GenericDialog;
import com.hero.util.XMLUtility;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class Armor extends Power {

	private static String xmlID = "ARMOR";

	private int edLevels;

	private int pdLevels;

	public Armor(Element root) {
		super(root, Armor.xmlID);
		canAffectPrimary = true;
	}

	@Override
	public boolean affectsCharacteristics() {
		return true;
	}

	@Override
	public String getColumn2Output() {
		String ret = getAlias() + " " + getDamageDisplay();
		if (getName().trim().length() > 0) {
			ret = "<i>" + getName() + ":</i>  " + ret;
		}
		ret += "(" + pdLevels + " PD/" + edLevels + " ED)";
		if ((getInput() != null) && (getInput().trim().length() > 0)) {
			ret += ":  " + getInput();
		}
		if (getSelectedOption() != null) {
			ret += " (";
			ret += getSelectedOption().getAlias();

			String adderString = getAdderString();
			if (adderString.trim().length() > 0) {
				ret += "; " + adderString;
			}
			ret += ")";
		} else {
			String adderString = getAdderString();
			if (adderString.trim().length() > 0) {
				ret += " (" + adderString + ")";
			}
		}
		ret += getModifierString();
		if ((getEndUsage() > 0)
				&& (GenericObject.findObjectByID(HeroDesigner.getActiveHero()
						.getPowers(), "ENDURANCERESERVE") != null)
				&& (GenericObject.findObjectByID(getAllAssignedModifiers(),
						"ENDRESERVEOREND") == null)
				&& !HeroDesigner.getInstance().getPrefs().useWG()) {
			if (getUseENDReserve()) {
				ret += " (uses END Reserve)";
			} else {
				ret += " (uses Personal END)";
			}
		}
		return ret;
	}

	@Override
	public String getDamageDisplay() {
		String ret = "";
		return ret;
	}

	@Override
	public GenericDialog getDialog(boolean isNew, boolean isPower) {
		return new ArmorDialog(this, isNew, isPower);
	}

	@Override
	public double getEdIncrease() {
		return getEdLevels();
	}

	@Override
	public int getEdIncreaseLevels() {
		return getLevels();
	}

	public int getEdLevels() {
		return edLevels;
	}

	/**
	 * Returns the sum of PD Levels and ED Levels
	 */
	@Override
	public int getLevels() {
		return pdLevels + edLevels;
	}

	@Override
	public double getPdIncrease() {
		return getPdLevels();
	}

	@Override
	public int getPdIncreaseLevels() {
		return getLevels();
	}

	public int getPdLevels() {
		return pdLevels;
	}

	@Override
	public Element getSaveXML() {
		Element root = super.getSaveXML();
		root.setAttribute("PDLEVELS", "" + pdLevels);
		root.setAttribute("EDLEVELS", "" + edLevels);
		return root;
	}

	/**
	 * Returns true.
	 */
	@Override
	public boolean resistantDefenses() {
		return true;
	}

	@Override
	public void restoreFromSave(Element root) {
		super.restoreFromSave(root);
		String check = XMLUtility.getValue(root, "PDLEVELS");
		if ((check != null) && (check.trim().length() > 0)) {
			try {
				pdLevels = Integer.parseInt(check);
			} catch (NumberFormatException ex) {
			}
		}
		check = XMLUtility.getValue(root, "EDLEVELS");
		if ((check != null) && (check.trim().length() > 0)) {
			try {
				edLevels = Integer.parseInt(check);
			} catch (NumberFormatException ex) {
			}
		}
		setLevels(edLevels + pdLevels);
	}

	public void setEdLevels(int edLevels) {
		this.edLevels = edLevels;
		setLevels(getPdLevels() + getEdLevels());
	}

	public void setPdLevels(int pdLevels) {
		this.pdLevels = pdLevels;
		setLevels(getPdLevels() + getEdLevels());
	}
}